﻿; tIRC -- History Review System
; Aladdin <fmillion@themillionweb.com>
; Modified for adiIRC by Arthur Pirika <arfy32@gmail.com>

alias firstline {
  %h.pos = 1
  .sout Moved to first line of history.
  %h.line = $read(%h.file,n,%h.pos)
  %h.len = $len(%h.line)
  %h.wordpos = 1
  %h.numwords = $numtok(%h.line,32)
  %h.select = %h.line
  .sout %h.line
  %h.charpos = 1
}
alias lastline {
  %h.pos = $lines(%h.file)
  %h.line = $read(%h.file,n,%h.pos)
  %h.charpos = 1
  %h.len = $len(%h.line)
  %h.wordpos = 1
  %h.select = %h.line
  %h.numwords = $numtok(%h.line,32)
  .sout Moved to last line of history.
  .sout %h.line
}
alias up {
  if (%h.pos != 1 ) /dec %h.pos 1
  %h.line = $read(%h.file,n,%h.pos)
  %h.len = $len(%h.len)
  %h.charpos = 1
  %h.wordpos = 1
  %h.numwords = $numtok(%h.line,32)
  %h.select = %h.line
  sout $iif(%h.pos == 1,top $+ $chr(44) %h.line,%h.line)
}
alias down {
  if (%h.pos != $lines(%h.file)) inc %h.pos
  %h.line = $read(%h.file,n,%h.pos)
  %h.len = $len(%h.line)
  %h.charpos = 1
  %h.numwords = $numtok(%h.line,32)
  %h.wordpos = 1
  %h.select = %h.line
  .sout $iif(%h.pos == $lines(%h.file),bottom $+ $chr(44) %h.line,%h.line)
}
on *:start:{
  .set %h.file " $+ $mircdir $+ temp\history.dat $+ "
  .set %c.file " $+ $mircdir $+ temp\clipboard.dat $+ "
  .set %h.pos 1
}

on *:exit:{
  .remove %h.file
  .unset %h.file
}

on *:close:@:{
  if ($target == @history) {
    .remove %h.file
    .remove %c.file
  }
}

alias f6 {
  history $active
}
alias history {
  if ($exists(%c.file) == $true ) .remove %c.file
  ; Save current active window in variable
  %h.window = $1
  ; Write the contents of the window to the buffer.
  if ($1- == status window ) /savebuf -s %h.file
  else .savebuf $active %h.file
  ; open the history window
  /window -axz @history 
  /sout History review active.
  ;Go to first line of history.
  lastline
}

on *:keyup:@history:*:{
  if ($keyval == 16 ) %shift.key = 0
  if ($keyval == 17 ) %control.key = 0
}
on *:keydown:@history:*:{
  if ($keyval == 27 ) {
    .window -c @history
    .sout Leaving history review.
    .remove %h.file
    .remove %c.file
    halt
  }
  if ($keyval == 16 ) %shift.key = 1
  if ($keyval == 17 ) %control.key = 1
  if ($keyval == 36) {
    ; move to first line 
    firstline
  }
  if ($keyval == 35) {
    ; move to last line
    lastline
  }
  if ($keyval == 38 ) {
    ; move up in the history
    up
  }
  if ($keyval == 40) {
    ; move down in the history
    down
  }
  if ($keyval == 32) {
    ; refresh history
    .remove %h.file
    if (%h.window == status window ) .savebuf -s %h.file
    else .savebuf %h.window %h.file
    .sout Refreshed history view.
  } 
  if ($keyval == 13 ) {
    ; speak info
    .sout Line %h.pos of $lines(%h.file) $+ , word number %h.wordpos of %h.numwords $+ , $gettok(%h.line,%h.wordpos,32)
  }
  if ($keychar == a ) {
    if ($read(%c.file,nts,%h.pos) != $null ) {
      speak This line was already added to the virtual clipboard.
      halt
    }
    .write %c.file %h.pos %h.select
    speak Line added to virtual clipboard.
  }
  if ($keychar == c ) {
    %i = 0
    %m = $lines(%c.file)
    .clipboard
    while (%i != %m ) {
      inc %i
      %data = $read(%c.file,n,%i)
      %line = $gettok(%data,2-,32)
      .clipboard -an %line
    }
    :done
    speak Moved virtual clipboard to system clipboard.
    .remove %c.file
  }
  if ($keyval == 37 ) {
    if (%h.line == %h.select ) %h.select = $mid(%h.len,1,1)
    if (%h.charpos == 0 ) up
    %h.char = $mid(%h.line,%h.charpos,1)
    if (%h.char = $chr(32)) dec %h.wordpos
    sout %h.char
    dec %h.charpos
  }  
  if ($keyval == 39 ) {
    if ($calc(%h.charpos - 2 ) == %h.len ) down
    %h.char = $mid(%h.line,%h.charpos,1)
    if (%h.char == $chr(32)) inc %h.wordpos
    if (%usingsr == 0 ) f4
    sout $mid(%h.line,%h.charpos,1)

    inc %h.charpos
  }
}