﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ColoredEmoji
{
    using System.IO;
    using System.Net;
    using AdiIRCAPIv2.Arguments.Aliasing;
    using AdiIRCAPIv2.Interfaces;

    public class ColoredEmoji : IPlugin
    {
        private string emojiDir = string.Empty;

        public string PluginDescription
        {
            get { return "Poor mans colored emojii"; }
        }

        public string PluginAuthor
        {
            get { return "Per Amundsen"; }
        }

        public string PluginName
        {
            get { return "Colored Emojii"; }
        }

        public string PluginVersion
        {
            get { return "1.0"; }
        }

        public string PluginEmail
        {
            get { return "amundsen@gmail.com"; }
        }

        public IPluginHost Host { get; set; }

        public void Initialize(IPluginHost host)
        {
            this.Host = host;

            this.emojiDir = Path.Combine(Path.Combine(Path.GetDirectoryName(this.ConfigFolder()), "Plugins"), "Emoji");

            this.Host.HookCommand("/loademoji", this.LoadEmoji);
            this.Host.HookCommand("/unloademoji", this.UnloadEmoji);
            this.Host.HookCommand("/printemoji", this.PrintEmoji);
        }

        private void LoadEmoji(RegisteredCommandArgs argument)
        {
            int count = 0;
            foreach (string file in Directory.GetFiles(this.emojiDir))
            {
                string emojii = string.Empty;
                string[] param = Path.GetFileNameWithoutExtension(file).Split('-');
                if (param.Length > 0)
                {
                    count++;

                    try
                    {
                        for (int i = 0; i < param.Length; i++)
                        {
                            emojii += char.ConvertFromUtf32(Convert.ToInt32(param[i], 16));
                        }

                        argument.Window.ExecuteCommand(string.Format("/writeini \"{0}\" Emoticons Emoticon_{1} {2}",
                            Path.Combine(this.Host.ConfigFolder, "config.ini"), emojii, this.ReplacePath(file)));
                    }
                    catch
                    {
                    }
                }
            }

            argument.Window.ExecuteCommand("/setoption");
            argument.Window.OutputText("Loaded " + count + " emojis");
        }

        private void UnloadEmoji(RegisteredCommandArgs argument)
        {
            int count = 0;

            foreach (string file in Directory.GetFiles(this.emojiDir))
            {
                string emojii = string.Empty;
                string[] param = Path.GetFileNameWithoutExtension(file).Split('-');

                if (param.Length > 0)
                {
                    count++;

                    try
                    {
                        for (int i = 0; i < param.Length; i++)
                        {
                            emojii += char.ConvertFromUtf32(Convert.ToInt32(param[i], 16));
                        }

                        argument.Window.ExecuteCommand(string.Format("/remini \"{0}\" Emoticons Emoticon_{1}",
                            Path.Combine(this.ConfigFolder(), "config.ini"), emojii));
                    }
                    catch
                    {
                    }
                }
            }

            argument.Window.OutputText("Unloaded " + count + " emojis");

            argument.Window.ExecuteCommand("/setoption");
        }

        private void PrintEmoji(RegisteredCommandArgs argument)
        {
            foreach (string file in Directory.GetFiles(this.emojiDir))
            {
                string emojii = string.Empty;
                string[] param = Path.GetFileNameWithoutExtension(file).Split('-');

                if (param.Length > 0)
                {
                    try
                    {
                        for (int i = 0; i < param.Length; i++)
                        {
                            emojii += char.ConvertFromUtf32(Convert.ToInt32(param[i], 16));
                        }
                    }
                    catch
                    {
                    }

                    argument.Window.ExecuteCommand("/echo -gw2 " + emojii);
                }
            }
        }

        private string ConfigFolder()
        {
            return this.Host.ConfigFolder;
        }

        private string ReplacePath(string file)
        {
            if (string.Compare(file, this.ConfigFolder(), StringComparison.OrdinalIgnoreCase) == 0)
            {
                return string.Empty;
            }

            return file.StartsWith(this.ConfigFolder(), StringComparison.OrdinalIgnoreCase)
                ? "." + Path.DirectorySeparatorChar + file.Substring(this.ConfigFolder().Length)
                : file;
        }

        public void Dispose()
        {
        }
    }
}
