﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Text;
using System.IO;
using AdiIRCAPI; // Include the API

namespace CoolFMLogin
{
    public class CoolFMLogin : IPlugin // Reference this is a plugin
    {
        private String myName = "CoolFMLogin";
        private String myDescription = "CoolFM Login Plugin";
        private String myAuthor = "Per Amundsen";
        private String myVersion = "1.0.0";
        private String myEmail = "amundsen@gmail.com"; // optional

        private static String _Username = "";
        private static String _Password = "";
        private static String _ConfDir = Application.StartupPath;
        private IServer _Server;

        IPluginHost myHost;
        ITools myTools;

        public string Description
        {
            get { return myDescription; }
        }

        public string Author
        {
            get { return myAuthor; }
        }

        public string Name
        {
            get { return myName; }
        }

        public string Version
        {
            get { return myVersion; }
        }

        public string Email
        {
            get { return myEmail; }
        }

        public IPluginHost Host
        {
            get { return myHost; }
            set { myHost = value; }
        }

        public ITools Tools
        {
            get { return myTools; }
            set { myTools = value; }
        }

        public static String ConfDir
        {
            get { return _ConfDir; }
        }

        public static String Username
        {
            get { return _Username; }
            set { _Username = value; }
        }

        public static String Password
        {
            get { return _Password; }
            set { _Password = value; }
        }

        private static Boolean CheckPermissions(string RunDir)
        {
            bool HazAccess;
            try
            {
                string p = RunDir + "\\" + "icanhazaccess.exe";
                FileStream F = File.Create(p);
                F.Close();
                if (File.Exists(p))
                {
                    File.Delete(p);
                }
                HazAccess = true;
            }
            catch (UnauthorizedAccessException)
            {
                HazAccess = false;
            }
            return HazAccess;
        }
        
        public void Initialize()
        {
            if (!CheckPermissions(_ConfDir))
            {
                _ConfDir = Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData) +
                        "\\" + "AdiIRC";
            }

            myHost.OnCommand += new Command(myHost_OnCommand);
            myHost.OnUserJoin += new UserJoin(myHost_OnUserJoin);
            myHost.HookCommand(this, "/vip", "/vip", "Giver dig +v VIP rettigheder på CoolFM");
            myHost.HookCommand(this, "/admin", "/admin", "Giver dig +ao admin rettigheder på CoolFM");
            myHost.HookCommand(this, "/vært", "/vært", "Giver dig +o vært rettigheder på CoolFM");
            myHost.HookCommand(this, "/indstil", "/indstil", "Viser CoolFM VIP indstilninger");

            if (!Directory.Exists(ConfDir))
            {
                try
                {
                    Directory.CreateDirectory(ConfDir);
                }
                catch (Exception err)
                {
                    MessageBox.Show(String.Format("Der opstod en fejl ved oprettelse af konfigurations filen: {0}",
                                                                err.Message),
                                                  "Fejl",
                                                  MessageBoxButtons.OK,
                                                  MessageBoxIcon.Error);
                }
            }

            if (!File.Exists(ConfDir + "\\CoolFMLogin.ini"))
            {
                Form1 f = new Form1();
                f.ShowDialog();
            }
            else
            {
                StreamReader tr = new StreamReader(ConfDir + "\\CoolFMLogin.ini");
                while (tr.Peek() >= 0)
                {
                    string line = tr.ReadLine();
                    string[] Param = line.Split('=');
                    if (Param[0] == "password")
                    {
                        _Password = Param[1];
                    }
                    else if (Param[0] == "username")
                    {
                        _Username = Param[1];
                    }
                }
                tr.Close();
            }
        }

        void myHost_OnCommand(object Window, string Command, string Args)
        {
            if (_Server != null)
            {
                if (String.Compare(Command, "/admin", true) == 0)
                {
                    myHost.SendRaw(_Server, String.Format("PRIVMSG Rynke :!admin {0} {1}", _Username, _Password));
                }
                else if (String.Compare(Command, "/vært", true) == 0)
                {
                    myHost.SendRaw(_Server, String.Format("PRIVMSG Rynke :!vært {0} {1}", _Username, _Password));
                }
                else if (String.Compare(Command, "/vip", true) == 0)
                {
                    myHost.SendRaw(_Server, String.Format("PRIVMSG Rynke :!voice {0} {1}", _Username, _Password));
                }
            }
            if (String.Compare(Command, "/indstil", true) == 0)
            {
                Form1 f = new Form1();
                f.textBox1.Text = _Username;
                f.textBox2.Text = _Password;
                f.ShowDialog();
            }
        }

        void myHost_OnUserJoin(IServer Server, IChannel Channel, out EatData Return)
        {
            if (String.Compare(Server.Network, "nordicirc", true) == 0
                && String.Compare(Channel.Name, "#coolfm", true) == 0)
            {
                _Server = Server;
                if (!String.IsNullOrEmpty(_Username)
                    && !String.IsNullOrEmpty(_Password))
                {
                    Server.SendRaw(String.Format("PRIVMSG Rynke :!voice {0} {1}", _Username, _Password));
                }
            }

            Return = EatData.EatNone;
        }

        public void Dispose()
        {
        }
    }
}
