﻿using System;
using System.Collections.Generic;
using System.Text;
using AdiIRCAPI; // Include the API

namespace AutoOpOnDeop
{
    public class AutoOpOnDeop : IPlugin // Reference this is a plugin
    {
        private String myName = "AutoOpOnDeop";
        private String myDescription = "Automatically op when deopped in a channel";
        private String myAuthor = "Per Amundsen";
        private String myVersion = "1.0.0";
        private String myEmail = "amundsen@gmail.com"; // optional

        IPluginHost myHost = null;
        ITools myTools = null;

        public string Description
        {
            get { return myDescription; }
        }

        public string Author
        {
            get { return myAuthor; }
        }

        public string Name
        {
            get { return myName; }
        }

        public string Version
        {
            get { return myVersion; }
        }

        public string Email
        {
            get { return myEmail; }
        }

        public IPluginHost Host
        {
            get { return myHost; }
            set { myHost = value; }
        }

        public ITools Tools
        {
            get { return myTools; }
            set { myTools = value; }
        }

        public AutoOpOnDeop()
        {

        }

        public void Initialize()
        {
            myHost.OnMode += new Mode(myHost_OnMode); // suscribe to mode messages
        }

        void myHost_OnMode(IServer Server, IChannel Channel, IUser User, string Mode, out EatData Return)
        {
            string[] Param = Mode.Split(' ');
            char[] chr = Param[0].ToCharArray();
            bool plusorminus = (chr[0] == '+' ? true : false);
            int pointer = 0;
            for (int i = 0; i < chr.Length; i++)
            {
                switch (chr[i])
                {
                    case '+':
                        plusorminus = true;
                        break;
                    case '-':
                        plusorminus = false;
                        break;
                    default:
                        {
                            char[] chars = Server.UserPrefixChars.ToCharArray();
                            for (int b = 0; b < chars.Length; b++)
                            {
                                if (chr[i] != chars[b]) continue;
                                pointer++;
                                if (pointer > Param.Length) continue;

                                if (String.Compare(Param[pointer], Server.Nick, true) != 0)
                                    continue;

                                if (b == 2 && !plusorminus) // I am beeing deopped
                                {
                                    myHost.SendCommand(Server, "/cs", String.Format("op {0} {1}", Channel, Server.Nick));
                                }
                            }
                        }
                        break;
                }
            }

            Return = EatData.EatNone;
        }

        public void Dispose()
        {
        }
    }
}
