﻿using System;
using AdiIRCAPI; // Include the API

namespace LockDown
{
    public class LockDown : IPlugin // Reference this is a plugin
    {
        private String myName = "LockDown";
        private String myDescription = "Lock down adiirc with a password";
        private String myAuthor = "Per Amundsen";
        private String myVersion = "1.0.0";
        private String myEmail = "amundsen@gmail.com"; // optional
        private string _Password = "";

        IPluginHost myHost = null;
        ITools myTools = null;

        public string Description
        {
            get { return myDescription; }
        }

        public string Author
        {
            get { return myAuthor; }
        }

        public string Name
        {
            get { return myName; }
        }

        public string Version
        {
            get { return myVersion; }
        }

        public string Email
        {
            get { return myEmail; }
        }

        public IPluginHost Host
        {
            get { return myHost; }
            set { myHost = value; }
        }

        public ITools Tools
        {
            get { return myTools; }
            set { myTools = value; }
        }

        public String Password
        {
            get { return _Password; }
        }

        public void Initialize()
        {
            myHost.HookCommand(this, "/lock", "/lock [password]", "Password to lock down with");
            myHost.OnCommand += (myHost_OnCommand);
        }

        void myHost_OnCommand(object Window, string Command, string Args)
        {
            if (string.Compare(Command,"/lock", true) == 0)
            {
                if (Args.Length == 0)
                {
                    if (Window.GetType() == typeof(IChannel))
                    {
                        myHost.NotifyUser((IChannel)Window, "Syntax is /lock [password]");
                    }
                    if (Window.GetType() == typeof(IServer))
                    {
                        myHost.NotifyUser((IServer)Window, "Syntax is /lock [password]");
                    }
                    if (Window.GetType() == typeof(IUser))
                    {
                        myHost.NotifyUser((IUser)Window, "Syntax is /lock [password]");
                    }
                }
                else
                {
                    _Password = Args;
                    Locked l = new Locked(this);
                    l.ShowDialog();
                }
            }
        }        

        public void Dispose()
        {
        }
    }
}
