﻿using System;
using System.Collections.Generic;
using System.Text;
using AdiIRCAPI;
using System.Xml;
using System.Net;

namespace SearchPlugin
{
    public class MyPlugin : IPlugin
    {
        private string myName = "Haxradio plugin";
        private string myDescription = "Haxradio plugin for AdiIRC";
        private string myAuthor = "Tayna Skerrett";
        private string myVersion = "1.0.0";
        private string myEmail = "admin@haxradio.com";
        private static int offset;
        private static int total;

        IPluginHost myHost = null;
        ITools myTools = null;

        public string Description
        {
            get { return myDescription; }
        }

        public string Author
        {
            get { return myAuthor; }
        }

        public string Name
        {
            get { return myName; }
        }

        public string Version
        {
            get { return myVersion; }
        }

        public string Email
        {
            get { return myEmail; }
        }

        public IPluginHost Host
        {
            get { return myHost; }
            set { myHost = value; }
        }

        public ITools Tools
        {
            get { return myTools; }
            set { myTools = value; }
        }



        public void Initialize()
        {

            myHost.HookCommand(this, "/search", "/search [query]", "Starts a bing search");
            myHost.OnCommand += new Command(myHost_OnCommand);

        }

     

        void myHost_OnCommand(object Window, string Command, string Args)
        {
            if (string.Compare(Command, "/search", true) == 0)
            {
                if (Args.Length == 0)
                {
                        myHost.NotifyUser("Syntax is /search [query]");
                }
                else
                {
                    BeginSearch(Args, 4);
                }
            }

        }

        public void BeginSearch(string terms, int count)
        {

            {
                StringBuilder builder = new StringBuilder();
                builder.Append("http://api.bing.net/xml.aspx?");
                builder.Append("AppId=121298B928E795F5C50946F49ABE3CDCD5D2C274");
                builder.Append("&Query=" + terms);
                builder.Append("&Sources=Web");
                builder.Append("&Version=2.0");
                builder.Append("&Market=en-us");
                builder.Append("&Adult=Moderate");
                builder.Append("&Web.Count=" + count);
                builder.Append("&Web.Offset=0");
                builder.Append("&Web.Options=DisableHostCollapsing+DisableQueryAlterations");
                HttpWebRequest request = WebRequest.Create(builder.ToString()) as HttpWebRequest;
                try
                {
                    HttpWebResponse response = request.GetResponse() as HttpWebResponse;
                    XmlDocument document = new XmlDocument();
                    document.Load(response.GetResponseStream());
                    XmlNamespaceManager nsmgr = new XmlNamespaceManager(document.NameTable);
                    nsmgr.AddNamespace("api", "http://schemas.microsoft.com/LiveSearch/2008/04/XML/element");
                    XmlNodeList errors = document.DocumentElement.SelectNodes("./api:Errors/api:Error", nsmgr);
                    DisplayResults(document.DocumentElement, nsmgr);
                }
                catch (WebException exception)
                {
                    throw new Exception(exception.Message);
                }
            }
        }


        private void DisplayResults(XmlNode root, XmlNamespaceManager nsmgr)
        {

            nsmgr.AddNamespace("web", "http://schemas.microsoft.com/LiveSearch/2008/04/XML/web");
            XmlNode node = root.SelectSingleNode("./web:Web", nsmgr);
            XmlNodeList list = node.SelectNodes("./web:Results/web:WebResult", nsmgr);
            string innerText = root.SelectSingleNode("./@Version", nsmgr).InnerText;
            string str2 = root.SelectSingleNode("./api:Query/api:SearchTerms", nsmgr).InnerText;

            int.TryParse(node.SelectSingleNode("./web:Offset", nsmgr).InnerText, out offset);
            int.TryParse(node.SelectSingleNode("./web:Total", nsmgr).InnerText, out total);
            foreach (XmlNode node2 in list)
            {
                string state = node2.SelectSingleNode("./web:Url", nsmgr).InnerText;
                string description = node2.SelectSingleNode("./web:Description", nsmgr).InnerText;
                myHost.NotifyUser(description);
                myHost.NotifyUser(state);
            }

        }
        public void Dispose()
        {

        }
    }
}
